; Compiled with: AVR Simulator IDE - Registered Copy v2.31
; Microcontroller model: ATtiny44
; Clock frequency: 1.0MHz
;
.EQU    R1716 = 0x010
.EQU    R1918 = 0x012
.EQU    R19181716 = 0x010
;       The value of 'none' (global) is 0
;       The value of 'single_short_click' (global) is 1
;       The value of 'double_short_click' (global) is 2
;       The value of 'single_long_click' (global) is 3
;       The address of 'button_state' (byte) (global) is 0x001
;       The address of 'bt_time' (byte) (global) is 0x003
;       The address of 'count_push' (byte) (global) is 0x002
;       The address of 'mode_push' (byte) (global) is 0x000
;       The address of 'button' (bit) (global) is 0x036,2
;       The address of 'power_on' (bit) (global) is 0x03B,3
;       The address of 'sound' (bit) (global) is 0x03B,4
;       The address of 'led_red' (bit) (global) is 0x03B,5
;       The address of 'led_blue' (bit) (global) is 0x03B,6
.ORG	0x000000
	RJMP L0005
.ORG	0x000001
	RJMP L0006
.ORG	0x000004
	RJMP L0007
L0008:
	POP R20
	POP R19
	POP R18
	POP R17
	POP R16
	POP R15
	POP R16
	OUT SREG,R16
	POP R16
	RETI
L0005:
	CLR R15
	LDI R16,0x5F
	OUT SPL,R16
	LDI R16,0x01
	OUT SPH,R16
	RJMP L0009
; User code start
L0009:
; 1: DDRA = %01111000
	LDI R16,0x78
	OUT DDRA,R16
; 2: DDRB = %00000000
	OUT DDRB,R15
; 3: 'WDTCSR = %00000000
; 4: 
; 5: '        
; 6: '    !   ? !
; 7: 'single_short_click (SSC)-  ,  .
; 8: 'double_short_click (DSC)-    ,       .
; 9: 'single_long_click (SLC)  ,    ,       .
; 10: '   :     .
; 11: '  - .
; 12: 
; 13: Const none = 0
; 14: Const single_short_click = 1
; 15: Const double_short_click = 2
; 16: Const single_long_click = 3
; 17: 
; 18: Dim button_state As Byte  '  
; 19: Dim bt_time As Byte  '   
; 20: Dim count_push As Byte  ' - 
; 21: Dim mode_push As Byte  '  
; 22: 
; 23: Symbol button = PINB.2
; 24: Symbol power_on = PORTA.3
; 25: Symbol sound = PORTA.4
; 26: Symbol led_red = PORTA.5
; 27: Symbol led_blue = PORTA.6
; 28: 
; 29: 
; 30: 'ASM:        WDR
; 31: 'WDTCSR = %01001000
; 32: 'PORTA.6 = 0
; 33: 'Enable EXT_INT0
; 34: 'Enable
; 35: 
; 36: main:
L0001:
; 37: WaitMs 50
	LDI R17,0xD1
	LDI R18,0x30
	RCALL DL02
; 38: Call button_scan()
	RCALL L0002
; 39: Call click_processing()
	RCALL L0004
; 40: 
; 41: Goto main
	RJMP L0001
; 42: 
; 43: End  '/***************************    ******************************/
L0010	RJMP L0010
; 44: 
; 45: Proc button_scan()
L0002:
; 46: 
; 47: Select Case button_state
; 48: 
; 49: Case 0  '     
	MOV R16,0x001
	LDI R17,0x00
	CPSE R16,R17
	RJMP L0011
; 50: If button = 0 Then button_state = 1
	SBIC PINB,2
	RJMP L0012
	LDI R16,0x01
	MOV 0x001,R16
L0012:
; 51: 'Goto end_select  '
; 52: 
; 53: Case 1  '   button_state = 1 -  
	RJMP L0013
L0011:
	MOV R16,0x001
	LDI R17,0x01
	CPSE R16,R17
	RJMP L0014
; 54: button_state = 2  '  
	LDI R16,0x02
	MOV 0x001,R16
; 55: mode_push = 0
	MOV 0x000,R15
; 56: count_push = 0
	MOV 0x002,R15
; 57: bt_time = 0  '  
	MOV 0x003,R15
; 58: Goto end_select  '
	RJMP L0003
; 59: 
; 60: Case 2
	RJMP L0015
L0014:
	MOV R16,0x001
	LDI R17,0x02
	CPSE R16,R17
	RJMP L0016
; 61: bt_time = bt_time + 1
	LDI R16,0x01
	ADD R16,0x003
	MOV 0x003,R16
; 62: count_push = ShiftLeft(count_push, 1)
	MOV R16,0x002
	MOV R17,R15
	LDI R18,0x01
	RCALL SL00
	MOV 0x002,R16
; 63: If button = 0 Then count_push.0 = 1  '  
	SBIC PINB,2
	RJMP L0017
	SET
	BLD 0x002,0
L0017:
; 64: If bt_time = 8 Then button_state = 3
	MOV R16,0x003
	LDI R17,0x08
	CPSE R16,R17
	RJMP L0018
	LDI R16,0x03
	MOV 0x001,R16
L0018:
; 65: Goto end_select  '
	RJMP L0003
; 66: 
; 67: Case 3
	RJMP L0019
L0016:
	MOV R16,0x001
	LDI R17,0x03
	CPSE R16,R17
	RJMP L0020
; 68: bt_time = bt_time + 1
	LDI R16,0x01
	ADD R16,0x003
	MOV 0x003,R16
; 69: If button = 1 Or bt_time > 15 Then  '     
	SBIS PINB,2
	RJMP L0023
	RJMP L0022
L0023:
	MOV R16,0x003
	LDI R17,0x0F
	CP R17,R16
	IN R18,SREG
	SBRS R18,SREG_C
	RJMP L0021
L0022:
; 70: button_state = 4  '   
	LDI R16,0x04
	MOV 0x001,R16
; 71: Endif
L0021:
; 72: Goto end_select  '
	RJMP L0003
; 73: 
; 74: Case 4  ' 
	RJMP L0024
L0020:
	MOV R16,0x001
	LDI R17,0x04
	CPSE R16,R17
	RJMP L0025
; 75: Select Case count_push  '  :
; 76: Case 0
	MOV R16,0x002
	LDI R17,0x00
	CPSE R16,R17
	RJMP L0026
; 77: mode_push = none
	MOV 0x000,R15
; 78: Case 128
	RJMP L0027
L0026:
	MOV R16,0x002
	LDI R17,0x80
	CPSE R16,R17
	RJMP L0028
; 79: mode_push = none  ' -   
	MOV 0x000,R15
; 80: Case 192
	RJMP L0029
L0028:
	MOV R16,0x002
	LDI R17,0xC0
	CPSE R16,R17
	RJMP L0030
; 81: mode_push = single_short_click
	LDI R16,0x01
	MOV 0x000,R16
; 82: Case 224
	RJMP L0031
L0030:
	MOV R16,0x002
	LDI R17,0xE0
	CPSE R16,R17
	RJMP L0032
; 83: mode_push = single_short_click
	LDI R16,0x01
	MOV 0x000,R16
; 84: Case 240
	RJMP L0033
L0032:
	MOV R16,0x002
	LDI R17,0xF0
	CPSE R16,R17
	RJMP L0034
; 85: mode_push = single_short_click
	LDI R16,0x01
	MOV 0x000,R16
; 86: Case 248
	RJMP L0035
L0034:
	MOV R16,0x002
	LDI R17,0xF8
	CPSE R16,R17
	RJMP L0036
; 87: mode_push = single_short_click
	LDI R16,0x01
	MOV 0x000,R16
; 88: Case 252
	RJMP L0037
L0036:
	MOV R16,0x002
	LDI R17,0xFC
	CPSE R16,R17
	RJMP L0038
; 89: mode_push = single_short_click
	LDI R16,0x01
	MOV 0x000,R16
; 90: Case 254
	RJMP L0039
L0038:
	MOV R16,0x002
	LDI R17,0xFE
	CPSE R16,R17
	RJMP L0040
; 91: mode_push = single_long_click
	LDI R16,0x03
	MOV 0x000,R16
; 92: Case 255
	RJMP L0041
L0040:
	MOV R16,0x002
	LDI R17,0xFF
	CPSE R16,R17
	RJMP L0042
; 93: mode_push = single_long_click
	LDI R16,0x03
	MOV 0x000,R16
; 94: Case Else
	RJMP L0043
L0042:
; 95: mode_push = double_short_click
	LDI R16,0x02
	MOV 0x000,R16
; 96: EndSelect  '
L0043:
L0041:
L0039:
L0037:
L0035:
L0033:
L0031:
L0029:
L0027:
; 97: button_state = 0
	MOV 0x001,R15
; 98: 'Enable
; 99: Goto end_select  '
	RJMP L0003
; 100: 
; 101: Case Else
	RJMP L0044
L0025:
; 102: 
; 103: end_select:
L0003:
; 104: EndSelect  '
L0044:
L0024:
L0019:
L0015:
L0013:
; 105: 
; 106: End Proc
	RET
; 107: 
; 108: Proc click_processing()
L0004:
; 109: 
; 110: If mode_push = none Then
	MOV R16,0x000
	LDI R17,0x00
	CPSE R16,R17
	RJMP L0045
; 111: PORTA = 255
	LDI R16,0xFF
	OUT PORTA,R16
; 112: Else
	RJMP L0046
L0045:
; 113: If mode_push = single_short_click Then led_blue = 0
	MOV R16,0x000
	LDI R17,0x01
	CPSE R16,R17
	RJMP L0047
	CBI PORTA,6
L0047:
; 114: If mode_push = single_long_click Then led_red = 0
	MOV R16,0x000
	LDI R17,0x03
	CPSE R16,R17
	RJMP L0048
	CBI PORTA,5
L0048:
; 115: If mode_push = double_short_click Then sound = 0
	MOV R16,0x000
	LDI R17,0x02
	CPSE R16,R17
	RJMP L0049
	CBI PORTA,4
L0049:
; 116: WaitMs 2000
	LDI R19,0xD0
	LDI R20,0x07
	RCALL W001
; 117: mode_push = none
	MOV 0x000,R15
; 118: Endif
L0046:
; 119: 
; 120: End Proc
	RET
; 121: 
; 122: On Interrupt WATCHDOG
L0007:
	PUSH R16
	IN R16,SREG
	PUSH R16
	PUSH R15
	PUSH R16
	PUSH R17
	PUSH R18
	PUSH R19
	PUSH R20
; 123: 
; 124: ASM:        WDR
	WDR
; 125: 
; 126: If PORTA.6 = 1 Then
	SBIS PORTA,6
	RJMP L0050
; 127: PORTA.6 = 0
	CBI PORTA,6
; 128: Else
	RJMP L0051
L0050:
; 129: PORTA.6 = 1
	SBI PORTA,6
; 130: Endif
L0051:
; 131: 
; 132: Resume
	RJMP L0008
; 133: 
; 134: On Interrupt EXT_INT0
L0006:
	PUSH R16
	IN R16,SREG
	PUSH R16
	PUSH R15
	PUSH R16
	PUSH R17
	PUSH R18
	PUSH R19
	PUSH R20
; 135: 
; 136: Disable
	CLI
; 137: button_state = 1
	LDI R16,0x01
	MOV 0x001,R16
; 138: power_on = 1
	SBI PORTA,3
; 139: 
; 140: Resume
	RJMP L0008
; End of user code
L0052	RJMP L0052
;
;
; Delay Routine Byte
; minimal routine execution time: 10s
; routine execution time step: 3s
; maximal routine execution time: 775s
DL01:
	SUBI R17,0x01
	BRCC DL01
	RET
; Delay Routine Word
; minimal routine execution time: 12s
; routine execution time step: 4s
; maximal routine execution time: 262152s
DL02:
	SUBI R17,0x01
	SBC R18,R15
	BRCC DL02
	RET
; Waitms Routine
W001:	SUBI R19,0x01
	SBC R20,R15
	BRCC W002
	RET
W002:
	LDI R17,0xF5
	LDI R18,0x00
	RCALL DL02
	RJMP W001
;
;
; Word ShiftLeft Routine
SL01:	LSL R16
	ROL R17
SL00:	SUBI R18,0x01
	BRCC SL01
	RET
;
;
; End of listing
