DDRA = %01111000
DDRB = %00000000
'WDTCSR = %00000000

'        
'    !   ? !
'single_short_click (SSC)-  ,  .
'double_short_click (DSC)-    ,       .
'single_long_click (SLC)  ,    ,       .
'   :     .
'  - .

Const none = 0
Const single_short_click = 1
Const double_short_click = 2
Const single_long_click = 3

Dim button_state As Byte  '  
Dim bt_time As Byte  '   
Dim count_push As Byte  ' - 
Dim mode_push As Byte  '  

Symbol button = PINB.2
Symbol power_on = PORTA.3
Symbol sound = PORTA.4
Symbol led_red = PORTA.5
Symbol led_blue = PORTA.6


'ASM:        WDR
'WDTCSR = %01001000
'PORTA.6 = 0
'Enable EXT_INT0
'Enable

main:
WaitMs 50
Call button_scan()
Call click_processing()

Goto main

End  '/***************************    ******************************/

Proc button_scan()

	Select Case button_state

		Case 0  '     
			If button = 0 Then button_state = 1
'Goto end_select  '

		Case 1  '   button_state = 1 -  
				button_state = 2  '  
				mode_push = 0
				count_push = 0
				bt_time = 0  '  
		Goto end_select  '
				
		Case 2
			bt_time = bt_time + 1
			count_push = ShiftLeft(count_push, 1)
			If button = 0 Then count_push.0 = 1  '  
			If bt_time = 8 Then button_state = 3
		Goto end_select  '
		
		Case 3
			bt_time = bt_time + 1
			If button = 1 Or bt_time > 15 Then  '     
				button_state = 4  '   
			Endif
		Goto end_select  '

		Case 4  ' 
			Select Case count_push  '  :
				Case 0
					mode_push = none
				Case 128
					mode_push = none  ' -   
				Case 192
					mode_push = single_short_click
				Case 224
					mode_push = single_short_click
				Case 240
					mode_push = single_short_click
				Case 248
					mode_push = single_short_click
				Case 252
					mode_push = single_short_click
				Case 254
					mode_push = single_long_click
				Case 255
					mode_push = single_long_click
				Case Else
					mode_push = double_short_click
			EndSelect  '
			button_state = 0
			'Enable
			Goto end_select  '

		Case Else
		
	end_select:
	EndSelect  '
	
End Proc                                          

Proc click_processing()

If mode_push = none Then
	PORTA = 255
Else
	If mode_push = single_short_click Then led_blue = 0
	If mode_push = single_long_click Then led_red = 0
	If mode_push = double_short_click Then sound = 0
	WaitMs 2000
	mode_push = none
Endif
	
End Proc                                          

On Interrupt WATCHDOG

ASM:        WDR

If PORTA.6 = 1 Then
	PORTA.6 = 0
Else
	PORTA.6 = 1
Endif

Resume                                            

On Interrupt EXT_INT0

Disable
button_state = 1
power_on = 1

Resume                                            
